<?php
/**
 * @package WordPress
 * @subpackage Medicure
 * @since Medicure 1.0
 * 
 * Sidebar Template
 * Created by CMSMasters
 * 
 */


$cmsms_option = cmsms_get_global_options();


if ( 
	!is_404() && 
	!is_archive() && 
	!is_search() && 
	!is_home() 
) {
	$sidebar_id = get_post_meta(get_the_ID(), 'cmsms_sidebar_id', true);
} else if (is_archive()) {
	$sidebar_id = $cmsms_option[CMSMS_SHORTNAME . '_archive_right_left_sidebar'];
} else if (is_search()) {
	$sidebar_id = $cmsms_option[CMSMS_SHORTNAME . '_search_right_left_sidebar'];
}


if (isset($sidebar_id) && is_dynamic_sidebar($sidebar_id) && is_active_sidebar($sidebar_id)) {
	dynamic_sidebar($sidebar_id);
} else if (is_active_sidebar('sidebar_default')) {
	dynamic_sidebar('sidebar_default');
} else {
	sidebarDefaultText();
}

