<?php
/**
 * @package WordPress
 * @subpackage Medicure
 * @since Medicure 1.0
 * 
 * Sidebar Template
 * Created by CMSMasters
 * 
 */


$cmsms_option = cmsms_get_global_options();


if ( 
	!is_404() && 
	!is_archive() && 
	!is_search() && 
	!is_home() 
) {
	$top_sidebar_id = get_post_meta(get_the_ID(), 'cmsms_top_sidebar_id', true);
} else if (is_archive()) {
	$top_sidebar_id = $cmsms_option[CMSMS_SHORTNAME . '_archive_top_sidebar'];
} else if (is_search()) {
	$top_sidebar_id = $cmsms_option[CMSMS_SHORTNAME . '_search_top_sidebar'];
}


if (isset($top_sidebar_id) && is_dynamic_sidebar($top_sidebar_id) && is_active_sidebar($top_sidebar_id)) {
	dynamic_sidebar($top_sidebar_id);
} else if (is_active_sidebar('sidebar_top')) {
	dynamic_sidebar('sidebar_top');
} else {
	sidebarDefaultText();
}

