<?php
/**
 * @package WordPress
 * @subpackage Medicure
 * @since Medicure 1.0
 * 
 * Sidebar Template
 * Created by CMSMasters
 * 
 */


$cmsms_option = cmsms_get_global_options();


if ( 
	!is_404() && 
	!is_archive() && 
	!is_search() && 
	!is_home() 
) {
	$bottom_sidebar_id = get_post_meta(get_the_ID(), 'cmsms_bottom_sidebar_id', true);
} else if (is_archive()) {
	$bottom_sidebar_id = $cmsms_option[CMSMS_SHORTNAME . '_archive_bottom_sidebar'];
} else if (is_search()) {
	$bottom_sidebar_id = $cmsms_option[CMSMS_SHORTNAME . '_search_bottom_sidebar'];
}


if (isset($bottom_sidebar_id) && is_dynamic_sidebar($bottom_sidebar_id) && is_active_sidebar($bottom_sidebar_id)) {
	dynamic_sidebar($bottom_sidebar_id);
} else if (is_active_sidebar('sidebar_bottom')) {
	dynamic_sidebar('sidebar_bottom');
} else {
	sidebarDefaultText();
}

