<?php
/**
 * @package WordPress
 * @subpackage Medicure
 * @since Medicure 1.0
 * 
 * Services Page Full Width Video Service Format Template
 * Created by CMSMasters
 * 
 */
 
 
$cmsms_option = cmsms_get_global_options();


global $cmsms_page_full_columns;


if (!$cmsms_page_full_columns) {
    $cmsms_page_full_columns = 'four_columns';
}

if ($cmsms_page_full_columns == 'four_columns' || $cmsms_page_full_columns == 'three_columns') {
    $s_img_size = 'service-thumb';
} elseif ($cmsms_page_full_columns == 'two_columns') {
    $s_img_size = 'service-thumb-half';
} elseif ($cmsms_page_full_columns == 'one_column') {
    $s_img_size = 'service-thumb-full';
}


$cmsms_service_featured_image_show = get_post_meta(get_the_ID(), 'cmsms_service_featured_image_show', true);

$s_sort_categs = get_the_terms(0, 's-sort-categs');

if ($s_sort_categs != '') {
	$s_categs = '';
	
	foreach ($s_sort_categs as $s_sort_categ) {
		$s_categs .= ' ' . $s_sort_categ->slug;
	}
	
	$s_categs = ltrim($s_categs, ' ');
}

$cmsms_service_video_type = get_post_meta(get_the_ID(), 'cmsms_service_video_type', true);
$cmsms_service_video_link = get_post_meta(get_the_ID(), 'cmsms_service_video_link', true);
$cmsms_service_video_links = get_post_meta(get_the_ID(), 'cmsms_service_video_links', true);

?>

<!--_________________________ Start Video Service _________________________ -->
<article id="post-<?php the_ID(); ?>" <?php post_class('format-video'); ?> data-category="<?php echo $s_categs; ?>">
	<div class="services_inner">
	<?php 
		if (has_post_thumbnail() && $cmsms_service_featured_image_show == 'true') {
			echo '<a href="' . get_permalink() . '"></a>' . 
			'<div class="media_box">' . 
				cmsms_thumb(get_the_ID(), $s_img_size, true, false, true, false, true, false, false) . 
			'</div>' . 
			'<div class="service_rollover">';
				cmsms_heading(get_the_ID(), 'service', true, 'h5');
			
				cmsms_meta('service', 'page', get_the_ID(), 's-sort-categs', 'fullwidth');
				
				cmsms_exc_cont('service');
			echo '</div>';
			
		} elseif ($cmsms_service_video_type == 'selfhosted' && !empty($cmsms_service_video_links) && sizeof($cmsms_service_video_links) > 0) {
			foreach ($cmsms_service_video_links as $cmsms_service_video_link_url) {
				$video_link[$cmsms_service_video_link_url[0]] = $cmsms_service_video_link_url[1];
			}
			
			if (has_post_thumbnail()) {
				$poster = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), $s_img_size);
				
				$video_link['poster'] = $poster[0];
			}
			
			echo '<div class="media_box cmsms_with_out_thumb">' . 
				cmsmastersSingleVideoPlayer($video_link) . 
			'</div>' . 
			'<div class="service_rollover cmsms_with_out_thumb">';
				cmsms_heading(get_the_ID(), 'service', true, 'h5');
			
				cmsms_meta('service', 'page', get_the_ID(), 's-sort-categs', 'fullwidth');
				
				cmsms_exc_cont('service');
			echo '</div>';
			
		} elseif ($cmsms_service_video_type == 'embedded' && $cmsms_service_video_link != '') {
			echo '<div class="media_box cmsms_with_out_thumb">' . 
				'<div class="resizable_block">' . 
					get_video_iframe($cmsms_service_video_link) . 
				'</div>' . 
			'</div>' . 
			'<div class="service_rollover cmsms_with_out_thumb">';
				cmsms_heading(get_the_ID(), 'service', true, 'h5');
			
				cmsms_meta('service', 'page', get_the_ID(), 's-sort-categs', 'fullwidth');
				
				cmsms_exc_cont('service');
			echo '</div>';
		}
	?>
	</div>
</article>
<!--_________________________ Finish Video Service _________________________ -->

