<?php
/**
 * @package WordPress
 * @subpackage Medicure
 * @since Medicure 1.0
 * 
 * Services Page Full Width Album Service Format Template
 * Created by CMSMasters
 * 
 */
 
 
$cmsms_option = cmsms_get_global_options();


global $cmsms_page_full_columns;


if (!$cmsms_page_full_columns) {
    $cmsms_page_full_columns = 'four_columns';
}

if ($cmsms_page_full_columns == 'four_columns' || $cmsms_page_full_columns == 'three_columns') {
    $s_img_size = 'service-thumb';
} elseif ($cmsms_page_full_columns == 'two_columns') {
    $s_img_size = 'service-thumb-half';
} elseif ($cmsms_page_full_columns == 'one_column') {
    $s_img_size = 'service-thumb-full';
}


$cmsms_service_featured_image_show = get_post_meta(get_the_ID(), 'cmsms_service_featured_image_show', true);
 
$cmsms_service_images = explode(',', str_replace(' ', '', str_replace('img_', '', get_post_meta(get_the_ID(), 'cmsms_service_images', true))));

$s_sort_categs = get_the_terms(0, 's-sort-categs');

if ($s_sort_categs != '') {
	$s_categs = '';
	
	foreach ($s_sort_categs as $s_sort_categ) {
		$s_categs .= ' ' . $s_sort_categ->slug;
	}
	
	$s_categs = ltrim($s_categs, ' ');
}
?>

<!--_________________________ Start Album Service _________________________ -->
<article id="album-template" <?php post_class('format-album'); ?> data-category="<?php echo $s_categs; ?>">
	<div class="services_inner">
		<a href="<?php echo get_permalink(); ?>"></a>
		<?php 
		if (has_post_thumbnail() && $cmsms_service_featured_image_show == 'true') {
				echo '<div class="media_box">' . 
					cmsms_thumb(get_the_ID(), $s_img_size, true, false, true, false, true, false, false) . 
				'</div>';
		} else if (sizeof($cmsms_service_images) > 0) {
			echo '<div class="media_box">' . 
				cmsms_thumb(get_the_ID(), $s_img_size, false, 'img_' . get_the_ID(), true, false, true, false, $cmsms_service_images[0]) . 
			'</div>';
		}
		
		if (sizeof($cmsms_service_images) > 1 && $cmsms_service_featured_image_show != 'true') {
			unset($cmsms_service_images[0]);
			
			echo '<div class="dn">';
			
			foreach ($cmsms_service_images as $cmsms_service_image) {
				$link_href = wp_get_attachment_image_src($cmsms_service_image, 'full');
				
				echo '<figure>' . 
					'<a href="' . $link_href[0] . '" data-group="img_' . get_the_ID() . '" title="' . cmsms_title(get_the_ID(), false) . '" class="preloader highImg jackbox">' . 
						wp_get_attachment_image($cmsms_service_image, $s_img_size, false, array( 
							'class' => 'fullwidth', 
							'alt' => cmsms_title(get_the_ID(), false), 
							'title' => cmsms_title(get_the_ID(), false) 
						)) . 
					'</a>' . 
				'</figure>';
			}
			
			echo '</div>';
		}
		?>
		<div class="service_rollover">
		<?php 	
			cmsms_heading(get_the_ID(), 'service', true, 'h5');
			
			cmsms_meta('service', 'page', get_the_ID(), 's-sort-categs', 'fullwidth');
			
			cmsms_exc_cont('service');
		?>
		</div>
	</div>
</article>
<!--_________________________ Finish Album Service _________________________ -->

