<?php
/**
 * @package WordPress
 * @subpackage Medicure
 * @since Medicure 1.0
 * 
 * Blog Post with Sidebar Standard Post Format Template
 * Created by CMSMasters
 * 
 */


$cmsms_post_featured_image_show = get_post_meta(get_the_ID(), 'cmsms_post_featured_image_show', true);

?>

<!--_________________________ Start Standard Article _________________________ -->
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="cmsms_info">
		<span class="cmsms_post_format_img"></span>
		<div class="cmsms_like"><?php cmsmsLike(); ?></div>
		<?php cmsms_post_date('post', 'post'); ?>
	</div>
	<div class="ovh">
		<header class="entry-header">
		<?php 
			if (!post_password_required()) {
				if (has_post_thumbnail() && $cmsms_post_featured_image_show == 'true') {
					cmsms_thumb(get_the_ID(), 'post-thumbnail', false, true, true, false, true, true, false);
				}
			}
			
			cmsms_heading_nolink(get_the_ID(), 'post', true, 'h2') . "\n"; 
		?>
			<div class="cmsms_post_info">
			<?php 
				cmsms_meta('post', 'post');
				
				if (!post_password_required()) {
					cmsms_comments('post', 'post');
				} 
			?>
			</div>
		</header>
		<?php 
		echo '<div class="entry-content">' . "\n";
			
			the_content();
			
			wp_link_pages(array( 
				'before' => '<div class="subpage_nav" role="navigation">' . '<strong>' . __('Pages', 'cmsmasters') . ':</strong>', 
				'after' => '</div>' . "\n", 
				'link_before' => ' [ ', 
				'link_after' => ' ] ' 
			));
			
			cmsms_content_composer(get_the_ID());
			
		echo "\t\t" . '</div>' . "\n";
		?>
		<div class="cl"></div>
		<footer class="entry-meta">
			<?php cmsms_tags(get_the_ID(), 'post', 'post'); ?>
		</footer>
	</div>
</article>
<!--_________________________ Finish Standard Article _________________________ -->

