<?php
/**
 * @package WordPress
 * @subpackage Medicure
 * @since Medicure 1.0
 * 
 * Blog Page with Sidebar Link Post Format Template
 * Created by CMSMasters
 * 
 */


$cmsms_post_link_text = get_post_meta(get_the_ID(), 'cmsms_post_link_text', true);
$cmsms_post_link_address = get_post_meta(get_the_ID(), 'cmsms_post_link_address', true);

if ($cmsms_post_link_text == '') {
	$cmsms_post_link_text = __('Enter link text', 'cmsmasters');
}

if ($cmsms_post_link_address == '') {
	$cmsms_post_link_address = '#';
}

?>

<!--_________________________ Start Link Article _________________________ -->
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="cmsms_info">
		<span class="cmsms_post_format_img"></span>
		<div class="cmsms_like"><?php cmsmsLike(); ?></div>
		<?php cmsms_post_date('post', 'page'); ?>
	</div>
	<div class="ovh">
	<?php 
		if (!post_password_required()) {
			echo '<h2 class="entry-title">' . 
				'<a href="' . $cmsms_post_link_address . '" target="_blank">' . $cmsms_post_link_text . '</a>' . 
			'</h2>' . "\n" . 
			'<h6>- ' . $cmsms_post_link_address . ' -</h6>';
		} else {
			echo '<h1 class="entry-title">' . $cmsms_post_link_text . '</h1>';
		}
	?>
		<header class="entry-header">
			<div class="cmsms_post_info">
			<?php 
				cmsms_meta('post', 'page');
				
				if (!post_password_required()) {
					cmsms_comments('page', 'post');
				}
			?>
			</div>
		</header>
		<?php
			cmsms_exc_cont('post');
			
			cmsms_more(get_the_ID(), 'post');
		?>
		<div class="cl"></div>
		<div class="divider"></div>
		<footer class="entry-meta">
			<?php cmsms_tags(get_the_ID(), 'post', 'page'); ?>
		</footer>
	</div>
</article>
<!--_________________________ Finish Link Article _________________________ -->

