<?php 

// template shortcode
function shortcode_templateurl() {
    return get_bloginfo('template_url');
}
add_shortcode('template_url', 'shortcode_templateurl');


// child themes shortcode

function shortcode_stylesheetdirectory() {
    return get_bloginfo('stylesheet_directory');
}
add_shortcode('stylesheet_directory', 'shortcode_stylesheetdirectory');


// home_url short code
function shortcode_homeurl(){
    return get_bloginfo('url');
}
add_shortcode('home_url','shortcode_homeurl');

remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'wp_shortlink_wp_head');




//投稿・固定ページ内にPHPファイル（子テーマ内）をインクルード(挿入/実行)させる
function Include_my_php($params = array()) {
	extract(shortcode_atts(array('file' => 'default'), $params));
	ob_start();
	get_template_part($file);
	return ob_get_clean();
}
add_shortcode('myphp', 'Include_my_php');


//サイドバー
if ( function_exists('register_sidebar') )
    register_sidebar(array(
		'name' => 'Right Sidebar Chicago Clinic',
		'description' => 'Widgets in this area will be shown in the right sidebar area of single posts.',
        'before_widget' => '<aside id="%1$s" class="widget %2$s left">',
        'after_widget' => '</aside>',
        'before_title' => '<h5>',
        'after_title' => '</h5>',
));


/* Register Theme Navigations */
register_nav_menus(array(
    'chicago_side' => __('Chicago Clinic Navigation', 'cmsmasters'),
    'sandiego_side' => __('Sandiego Clinic Navigation', 'cmsmasters')
));

