<?php 
/**
 * @package WordPress
 * @subpackage Medicure
 * @since Medicure 1.0
 * 
 * Fonts & Colors Settings File
 * Created by CMSMasters
 * 
 */


header('Content-type: text/css');


require('../../../../wp-load.php');


$cmsms_option = cmsms_get_global_options();

?>

/* ===================> Fonts <================== */

/* ====> Content <==== */

body, 
li p,
.cmsms_sitemap > li ul > li ul li > a {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_content_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_content_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_content_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_content_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_content_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_content_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_content_font_font_style']; ?>;
}


/* ====> Links <==== */

a {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_link_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_link_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_link_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_link_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_link_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_link_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_link_font_font_style']; ?>;
}

/* ====> Navigation <==== */

#navigation > li > a {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_font_style']; ?>;
}

#navigation ul li a {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_nav_dropdown_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_nav_dropdown_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_nav_dropdown_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_nav_dropdown_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_nav_dropdown_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_dropdown_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_dropdown_font_font_style']; ?>;
}


/* ====> Headings <==== */

h1,
h1 a,
.logo .title {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_h1_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_h1_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_h1_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_h1_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_h1_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h1_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h1_font_font_style']; ?>;
}

h2,
h2 a, 
.cmsms_sitemap > li > a,
.colored_button {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_h2_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_h2_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_h2_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_h2_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_h2_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h2_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h2_font_font_style']; ?>;
}

h3,
h3 a,
.cmsms_sitemap > li > a {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_h3_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_h3_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_h3_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_h3_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_h3_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h3_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h3_font_font_style']; ?>;
}

h4,
h4 a {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_h4_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_h4_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_h4_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_h4_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_h4_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h4_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h4_font_font_style']; ?>;
}

h5,
h5 a,
.cmsms_our_team_wrap .person_title,
.cmsms_our_team_wrap .person_title a {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_h5_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_h5_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_h5_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_h5_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_h5_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h5_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h5_font_font_style']; ?>;
}

.service_rollover .entry-header h5, 
.service_rollover .entry-header h5 a {font-size:17px;}

h6,
h6 a,
.tog,
.tabs li a,
.tour li a,
.cmsms_sitemap > li ul > li > a, 
.format-quote .cmsms_author,
.percent_item_text,
.table thead th,
.table tfoot th,
.cmsms_pricing_table .cmsms_price_outer span,
.testimonial a.tl_author, 
.opened-article .testimonial a.tl_author, 
.cmsms_our_team_wrap .person_subtitle {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_h6_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_h6_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_h6_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_h6_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_h6_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h6_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h6_font_font_style']; ?>;
}

.cmsms_pricing_table .period {
	font-size:13px;
}

.tog,
.widget_custom_popular_services_entries .service_title,
.widget_custom_popular_services_entries .service_title a, 
.widget_custom_latest_services_entries .service_title,
.widget_custom_latest_services_entries .service_title a {
	font-size:16px;
} 

.pricing_button,
.button,
.button_small, 
.button_medium,
.button_large,
.button_small.cmsms_share,
.entry .project_navi a, 
#cancel-comment-reply-link,
#wp-calendar, 
#submit,
input[type="submit"],
.cmsms_info .cmsms_page_day, 
.cmsms_info .cmsms_post_day, 
.cmsms_info .cmsms_page_year, 
.cmsms_info .cmsms_page_month, 
.cmsms_info .cmsms_post_year, 
.cmsms_info .cmsms_post_month {
	font-family:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_h6_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_h6_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo (($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_h6_font_system_font'];
	?>;
}


/* ====> Other <==== */

q, 
blockquote {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_quote_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_quote_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_quote_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_quote_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_quote_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_quote_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_quote_font_font_style']; ?>;
}

q:before, 
blockquote:before {
	font-family:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_content_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_content_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo (($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_content_font_system_font'];
	?>;
	
	font-size:70px;
	line-height:1em;
}

span.dropcap,
span.dropcap2 {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_dropcap_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_dropcap_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_dropcap_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_dropcap_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_dropcap_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_dropcap_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_dropcap_font_font_style']; ?>;
}

span.dropcap2 {
	font-size:40px;
	line-height:40px;
	height:40px;
}

code {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_code_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_code_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_code_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_code_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_code_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_code_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_code_font_font_style']; ?>;
}

small,
small a, 
.cmsms_post_info, 
.cmsms_post_info *,
.cmsms_tags, 
.cmsms_tags * {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_small_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_small_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_small_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_small_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_small_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_small_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_small_font_font_style']; ?>;
}
	
input,
textarea,
select,
option {
	font:<?php 
		if ($cmsms_option[CMSMS_SHORTNAME . '_input_font_google_font'] != '') {
			$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_input_font_google_font']);
			
			$google_font = str_replace('+', ' ', $google_font_array[0]);
		} else {
			$google_font = '';
		}
		
		echo $cmsms_option[CMSMS_SHORTNAME . '_input_font_font_size'] . 
		'px/' . 
		$cmsms_option[CMSMS_SHORTNAME . '_input_font_line_height'] . 
		'px ' . 
		(($google_font != '') ? "'" . $google_font . "', " : '') . 
		$cmsms_option[CMSMS_SHORTNAME . '_input_font_system_font'];
	?>;
	font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_input_font_font_weight']; ?>;
	font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_input_font_font_style']; ?>;
}


/* ===================> Colors <================== */

/* ====> Content <==== */

body, 
ul.s_filter_list li a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_content_font_font_color']; ?>;
}

#bottom,
.bottom_inner .widget_custom_twitter_entries .tweet_time a:before,
.bottom_inner #wp-calendar caption,
.bottom_inner #wp-calendar tbody td,
.bottom_inner .widget .tl_company {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_bottom_content_font_color']; ?>;
}

#bottom h1, 
#bottom h2, 
#bottom h3, 
#bottom h4, 
#bottom h5, 
#bottom h6 {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_bottom_headings_color']; ?>;
}

#footer {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_footer_font_color']; ?>;
}


/* ====> Links <==== */

a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_link_font_font_color']; ?>;
}

a:hover,
.tab.lpr .tab_content .ovh a:hover, 
.service_sidebar .cmsmsLike.active,
.header_html > span[class*="contact"],
.post_type_shortcode.type_post .entry-title a:hover {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_link_font_hover']; ?>;
}

#bottom a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_bottom_link_font_color']; ?>;
}

#bottom a:hover,
.tabs li a:hover,
.color_3,
.related_posts ul > li > a:hover,
.cmsms_pricing_table .currency, 
.cmsms_pricing_table .price, 
.cmsms_pricing_table .coins,
#wp-calendar #today,
q:before, blockquote:before,
.widget_custom_services_entries_slides .service_title a,
.error_page h1,.widget_custom_twitter_entries .tweet_time a:before,
.contact_widget_info > span:before,
.widget_custom_contact_info_entries > span[class*="contact"]:before {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_bottom_link_font_hover']; ?>;
}

#footer a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_footer_link_font_color']; ?>;
}

#footer a:hover {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_footer_link_font_hover']; ?>;
}

/* ====> Navigation <==== */

#navigation li > a,
#header .header_html > span[class*="contact"],
#header .header_html > span[class*="contact"] a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_font_color']; ?>;
}


#navigation > li.current_page_item > a > span,
#navigation li.current_page_ancestor > a,
#navigation li.current-menu-ancestor > a,
#navigation li:hover > a:hover,
#navigation li:hover > a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_hover']; ?>;
}

#navigation ul li > a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_dropdown_font_font_color']; ?>;
}

#navigation li li.current_page_item > a,
#navigation li li.current_page_ancestor > a,
#navigation li li.current-menu-ancestor > a,
#navigation li li:hover > a:hover,
#navigation ul li:hover > a,
.post_type_shortcode.type_post .entry-title a,
.cmsms_our_team_wrap .person_title a:hover,
.cmsms_our_team_wrap .person_subtitle,
.tab.lpr .tab_content .ovh a,
.testimonial .tl_company,
.widget .tl_company,
.title_1 {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_dropdown_font_hover']; ?>;
}


/* ====> Headings <==== */

h1,
h1 a, 
.logo {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h1_font_font_color']; ?>;
}

h2,
h2 a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h2_font_font_color']; ?>;
}

h3, 
h3 a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h3_font_font_color']; ?>;
}

h4,
h4 a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h4_font_font_color']; ?>;
}

h5, 
h5 a, 
ul.s_filter_list li a:hover, 
ul.s_filter_list li.current a,
.pricing_button,
.button,
.button_small, 
.button_medium,
.button_large, 
#cancel-comment-reply-link,
#submit,
input[type="submit"],
.cmsms_features_item_title, 
.cmsms_details_item_title, 
.cmsms_info .cmsms_page_day, 
.cmsms_info .cmsms_post_day, 
.cmsms_info .cmsms_page_year, 
.cmsms_info .cmsms_page_month, 
.cmsms_info .cmsms_post_year, 
.cmsms_info .cmsms_post_month, 
.format-quote .cmsms_author,
.testimonial a.tl_author,
.opened-article .testimonial a.tl_author {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h5_font_font_color']; ?>;
}

h6,
h6 a {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_h6_font_font_color']; ?>;
}


/* ====> Other <==== */

q, 
blockquote {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_quote_font_font_color']; ?>;
}

span.dropcap {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_dropcap_font_font_color']; ?>;
}

span.dropcap2,
.tog,
.tog:hover,
.tabs li a,
.bottom_inner .tabs li.current a span, 
.tour li a span,
.related_posts ul li a,
.percent_item_text,
.cmsms_sitemap > li > a,
#wp-calendar caption,
#wp-calendar tbody tr td {
	color:#3b3b3b;
}

code {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_code_font_font_color']; ?>;
}

small {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_small_font_font_color']; ?>;
}

input,
textarea,
select,
select option {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_input_font_font_color']; ?>;
}

.color_1,
#header .search_line form p:before,
.header_html > span[class*="contact"]:before {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color1']; ?>;
}

.color_2, 
.cmsms_info .cmsms_like .cmsmsLike:hover:before,
.cmsms_info .cmsms_like .cmsmsLike.active:before,
.cmsms_info .cmsms_like .cmsmsLike.active span,
.cmsms_info .cmsms_like .cmsmsLike.active:hover span {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color2']; ?>;
}


.project_navi a[rel="prev"]:hover,
.project_navi a[rel="next"]:hover {
	color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_3']; ?>;
}

input#submit:hover,
.button:hover,
.button_small:hover,
.button_medium:hover,
.button_large:hover,
.button.current,
.button_small.current,
.button_medium.current, 
.button_large.current,
.tabs li.current a,
.tour  > li.current a > span, 
.tour  > li a:hover > span,
.related_posts ul > li .current,
.related_posts ul > li .current:hover,
.s_cat_filter.button_small:hover,
.s_sort a.button_small:hover, 
.s_cat_filter.button_small.current, 
.s_sort a.button_small.current, 
.cmsms_pricing_table .pricing_footer .pricing_button:hover, 
.comment-reply-link:hover, 
#cancel-comment-reply-link:hover, 
.s_filter_container:hover .s_cat_filter.button_small,
.percent_item_colored > span,
.cmsms_post_format_img:before,
.cmsms_info .cmsms_like .cmsmsLike:before, 
.cmsms_info .cmsms_like .cmsmsLike:hover span,
.testimonial blockquote:before,
.widget .tl-content:before,
#bottom #wp-calendar #today,
#cmsms_latest_bottom_tweets,
#cmsms_latest_bottom_tweets a,
.format-quote blockquote:before, 
ul li a.page-numbers:hover,
.colored_banner,
.colored_banner h1,
.colored_banner h2 {
	color:#ffffff;
}

.bottom_inner a.button_small,
.bottom_inner a.button_medium,
.bottom_inner a.button_large {
	color:#3b3b3b !important;
}

.bottom_inner a.button_small:hover,
.bottom_inner a.button_medium:hover,
.bottom_inner a.button_large:hover {
	color:#ffffff !important;
}


/* ===================> Backgrounds and Borders <================== */

.bg_color_1, 
h3:after, 
input#submit:hover, 
.button:hover, 
.button_small:hover, 
.button_medium:hover, 
.button_large:hover, 
.button.current, 
.button_small.current,
.button_medium.current,
.button_large.current,
.responsive_nav span,
.responsive_nav span:before,
.responsive_nav span:after,
.tabs li.current a,
.cmsms_sitemap > li > a:after, 
.s_cat_filter.button_small:hover, 
.s_sort a.button_small:hover,
.s_cat_filter.button_small.current,
.s_sort a.button_small.current, 
.cmsms_pricing_table .pricing_footer .pricing_button:hover, 
.comment-reply-link:hover, 
#cancel-comment-reply-link:hover, 
.s_filter_container:hover .s_cat_filter.button_small,
.tog:hover .cmsms_plus span,
.tog.current .cmsms_plus,
.cmsms_post_format_img, 
.format-quote blockquote:before, 
ul li a.page-numbers:hover,
#cmsms_latest_bottom_tweets,
.wrap_person .cmsms_link:hover,
.wrap_person .cmsms_link:before,
.wrap_person .cmsms_link > span:before,
.wrap_person .cmsms_link > span:after,
.testimonial blockquote:after,
.widget .tl-content:after,
.cmsms_latest_bottom_tweets_inner .cmsms_content_prev_slide,
.cmsms_latest_bottom_tweets_inner .cmsms_content_next_slide,
.cmsms_content_prev_slide:active,
.cmsms_content_next_slide:active,
.cmsms_content_slider_parent ul.cmsms_slides_nav li.active a,
.tp-bullets.simplebullets.round .bullet:hover,
.tp-bullets.simplebullets.round .bullet.selected {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color1']; ?>;
}

.ls-medicure .ls-nav-stop:hover:before,
.ls-medicure .ls-nav-stop:hover:after,
.ls-medicure .ls-nav-stop-active:before,
.ls-medicure .ls-nav-stop-active:after,
.ls-medicure .ls-bottom-slidebuttons a:hover,
.ls-medicure .ls-bottom-slidebuttons a.ls-nav-active {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color1']; ?> !important;
}


.bg_color_2, 
.cmsms_info .cmsms_like .cmsmsLike,
.cmsms_info .cmsms_like .cmsmsLike:hover {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color2']; ?>;
}

.comment-reply-link,
.pricing_button,
.button,
.button_small,
.button_medium,
.button_large,
.bottom_inner .tabs li.current a,
.tog.current .cmsms_plus span,
#cancel-comment-reply-link,
#submit,
input[type="submit"], 
.services_inner .service_rollover,
.wrap_person .cmsms_link:hover:before,
.wrap_person .cmsms_link:hover > span:before,
.wrap_person .cmsms_link:hover > span:after,
.cmsms_latest_bottom_tweets_inner .cmsms_content_prev_slide:hover,
.cmsms_latest_bottom_tweets_inner .cmsms_content_next_slide:hover,
.bottom_inner .cmsms_content_prev_slide:hover,
.bottom_inner .cmsms_content_next_slide:hover {
	background-color:#ffffff;
}


.glow_blue {background:#33bee5;}

.glow_green {background:#6cc437;}

.glow_yellow {background:#fabe09;}

.glow_red {background:#f97a14;}

.colored_title_inner.glow_blue {background-color:#33bee5;}

.colored_title_inner.glow_green {background-color:#6cc437;}

.colored_title_inner.glow_yellow {background-color:#fabe09;}

.colored_title_inner.glow_red {background-color:#f97a14;}



input#submit:hover, 
.button:hover, 
.button_small:hover, 
.button_medium:hover, 
.button_large:hover, 
.button.current, 
.button_small.current, 
.button_medium.current, 
.button_large.current,
.tog.current .cmsms_plus,
.s_cat_filter.button_small:hover, 
.s_sort a.button_small:hover, 
.s_cat_filter.button_small.current, 
.s_sort a.button_small.current, 
.cmsms_pricing_table .pricing_footer .pricing_button:hover, 
.wrap_person .cmsms_link:after, 
.comment-reply-link:hover, 
#cancel-comment-reply-link:hover,
input[type="text"]:focus,
input[type="email"]:focus,
input[type="tel"]:focus,
textarea:focus,
select:focus,
.s_filter_container:hover .s_cat_filter.button_small, 
ul li a.page-numbers:hover {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color1']; ?>;
}

.social_toggle.current span:before {
	border-bottom-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color1']; ?>;
}

.s_cat_filter.button_small span:before, 
.s_sort .button_small span:before {
	border-top-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color1']; ?>;
}

.cmsms_info .cmsms_like .cmsmsLike:hover,
.cmsms_info .cmsms_like .cmsmsLike.active {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color2']; ?>;
}

.bottom_inner .cmsms_content_prev_slide,
.bottom_inner .cmsms_content_next_slide {
	border-color:#464646;
}

.icon_banner:before,
code {
	border-top-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_3']; ?>;	
}

.colored_button:hover .icon_banner {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_3']; ?>;	
}

.cmsms_content_prev_slide:hover:before,
.rtl .cmsms_content_next_slide:hover:before {
	border-right-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color1']; ?>;
}
.cmsms_content_next_slide:hover:before,
.rtl .cmsms_content_prev_slide:hover:before  {
	border-left-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color1']; ?>;
}

#slide_top:hover:before {
	border-bottom-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color1']; ?>;
}

.project_navi a[rel="prev"]:before,
.rtl .project_navi a[rel="next"]:before {
	border-right-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_3']; ?>;	
}

.project_navi a[rel="next"]:before,
.rtl .project_navi a[rel="prev"]:before,
.table thead th:first-child {
	border-left-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_3']; ?>;	
}

.table thead th {
	border-top-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_3']; ?>;	
}

.ls-medicure .ls-nav-start:hover:before,
.ls-medicure .ls-nav-start-active:before {
	border-left-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_theme_color1']; ?> !important;
}

.bottom_inner .cmsms_content_prev_slide:before {
	border-right-color:#989898;
}

.bottom_inner .cmsms_content_next_slide:before {
	border-left-color:#989898;
}


/* ===================> Current Tab Border Colors <================== */

.tabs > li.current a,
.related_posts ul > li > a.current {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_1']; ?>;
}

.tabs > li + li.current a,
.related_posts ul > li + li > a.current {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_2']; ?>;
}

.tabs > li + li + li.current a,
.related_posts ul > li + li + li > a.current {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_3']; ?>;
}

.tabs > li + li + li + li .current a,
.related_posts ul > li + li + li + li > a.current {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_4']; ?>;
}

.tabs > li + li + li + li + li + li .current a,
.related_posts ul > li + li + li + li + li > a.current {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_5']; ?>;
}

.tabs > li + li + li + li + li + li + li.current a,
.related_posts ul > li + li + li + li + li + li > a.current {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_6']; ?>;
}

.tabs > li + li + li + li + li + li + li + li.current a,
.related_posts ul > li + li + li + li + li + li + li > a.current {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_7']; ?>;
}

.tabs > li + li + li + li + li + li + li + li + li.current a,
.related_posts ul > li + li + li + li + li + li + li + li > a.current {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_8']; ?>;
}

.tabs > li + li + li + li + li + li + li + li + li + li.current a,
.related_posts ul > li + li + li + li + li + li + li + li + li > a.current {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_9']; ?>;
}

.tabs > li + li + li + li + li + li + li + li + li + li + li.current a,
.related_posts ul > li + li + li + li + li + li + li + li + li + li > a.current {
	border-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_10']; ?>;
}

.bottom_inner input[type="text"]:focus,
.bottom_inner input[type="email"]:focus,
.bottom_inner input[type="tel"]:focus,
.bottom_inner textarea:focus,
.bottom_inner select:focus {
	border-color:#ffffff;
}

.s_sort .button_small:hover span:before, 
.s_sort .button_small.current span:before {
	border-top-color:#ffffff;
}

.s_cat_filter.button_small:hover span:before, 
.s_filter_container:hover .s_cat_filter.button_small span:before, 
.s_sort .button_small.current.reversed span:before {
	border-bottom-color:#ffffff;
}

ul li .page-numbers.prev:hover:before,
.rtl ul li .page-numbers.next:hover:before {
	border-right-color:#ffffff;
}

ul li .page-numbers.next:hover:before,
.rtl ul li .page-numbers.prev:hover:before {
	border-left-color:#ffffff;
}


@media only screen and (max-width: 1024px) {

	#navigation li > a,
	#navigation li li.current_page_item > a,
	#navigation li li.current_page_ancestor > a,
	#navigation li li.current-menu-ancestor > a,
	#navigation li li:hover > a:hover,
	#navigation ul li:hover > a {
		color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_dropdown_font_font_color']; ?>;
	}
	
	#navigation ul li a {
		font:<?php 
			if ($cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_google_font'] != '') {
				$google_font_array = explode(':', $cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_google_font']);
				
				$google_font = str_replace('+', ' ', $google_font_array[0]);
			} else {
				$google_font = '';
			}
			
			echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_font_size'] . 
			'px/' . 
			$cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_line_height'] . 
			'px ' . 
			(($google_font != '') ? "'" . $google_font . "', " : '') . 
			$cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_system_font'];
		?>;
		font-weight:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_font_weight']; ?>;
		font-style:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_font_font_style']; ?>;
	}

}


/* ===================> Navigation Hover Background Colors <================== */

#navigation > li:hover > a, 
#navigation > li:hover > a:hover, 
#navigation > li.current_page_item > a, 
#navigation > li.current_page_ancestor > a, 
#navigation > li.current-menu-ancestor > a,
.related_posts ul > li > a.current,
.tabs > li.current a, 
.tour  > li a:hover, 
.tour  > li.current a {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_1']; ?>;
}

#navigation > li + li:hover > a, 
#navigation > li + li:hover > a:hover, 
#navigation > li + li.current_page_item > a, 
#navigation > li + li.current_page_ancestor > a, 
#navigation > li + li.current-menu-ancestor > a,
.related_posts ul > li + li > a.current,
.tabs > li + li.current a,
.tour  > li + li a:hover,
.tour  > li + li.current a {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_2']; ?>;
}

#navigation > li + li + li:hover > a, 
#navigation > li + li + li:hover > a:hover, 
#navigation > li + li + li.current_page_item > a, 
#navigation > li + li + li.current_page_ancestor > a, 
#navigation > li + li + li.current-menu-ancestor > a,
.related_posts ul > li + li + li > a.current,
.tabs > li + li + li.current a,
.tour  > li + li + li a:hover, 
.tour  > li + li + li.current a,
.table thead th,
span.dropcap {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_3']; ?>;
}

#navigation > li + li + li + li:hover > a, 
#navigation > li + li + li + li:hover > a:hover, 
#navigation > li + li + li + li.current_page_item > a, 
#navigation > li + li + li + li.current_page_ancestor > a, 
#navigation > li + li + li + li.current-menu-ancestor > a,
.related_posts ul > li + li + li + li > a.current,
.tabs > li + li + li + li.current a, 
.tour  > li + li + li + li a:hover, 
.tour  > li + li + li + li.current a {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_4']; ?>;
}

#navigation > li + li + li + li + li:hover > a, 
#navigation > li + li + li + li + li:hover > a:hover, 
#navigation > li + li + li + li + li.current_page_item > a, 
#navigation > li + li + li + li + li.current_page_ancestor > a, 
#navigation > li + li + li + li + li.current-menu-ancestor > a,
.related_posts ul > li + li + li + li + li > a.current,
.tabs > li + li + li + li + li.current a,
.tour  > li + li + li + li + li a:hover, 
.tour  > li + li + li + li + li.current a {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_5']; ?>;
}

#navigation > li + li + li + li + li + li:hover > a, 
#navigation > li + li + li + li + li + li:hover > a:hover, 
#navigation > li + li + li + li + li + li.current_page_item > a, 
#navigation > li + li + li + li + li + li.current_page_ancestor > a, 
#navigation > li + li + li + li + li + li.current-menu-ancestor > a,
.related_posts ul > li + li + li + li + li + li > a.current,
.tabs > li + li + li + li + li + li.current a, 
.tour  > li + li + li + li + li + li a:hover, 
.tour  > li + li + li + li + li + li.current a {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_6']; ?>;
}

#navigation > li + li + li + li + li + li + li:hover > a, 
#navigation > li + li + li + li + li + li + li:hover > a:hover,
#navigation > li + li + li + li + li + li + li.current_page_item > a, 
#navigation > li + li + li + li + li + li + li.current_page_ancestor > a, 
#navigation > li + li + li + li + li + li + li.current-menu-ancestor > a,
.related_posts ul > li + li + li + li + li + li + li > a.current,
.tabs > li + li + li + li + li + li + li.current a,
.tour  > li + li + li + li + li + li + li a:hover, 
.tour  > li + li + li + li + li + li + li.current a {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_7']; ?>;
}

#navigation > li + li + li + li + li + li + li + li:hover > a, 
#navigation > li + li + li + li + li + li + li + li:hover > a:hover, 
#navigation > li + li + li + li + li + li + li + li.current_page_item > a, 
#navigation > li + li + li + li + li + li + li + li.current_page_ancestor > a, 
#navigation > li + li + li + li + li + li + li + li.current-menu-ancestor > a,
.related_posts ul > li + li + li + li + li + li + li + li > a.current,
.tabs > li + li + li + li + li + li + li + li.current a, 
.tour  > li + li + li + li + li + li + li + li a:hover, 
.tour  > li + li + li + li + li + li + li + li.current a {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_8']; ?>;
}

#navigation > li + li + li + li + li + li + li + li + li:hover > a, 
#navigation > li + li + li + li + li + li + li + li + li:hover > a:hover, 
#navigation > li + li + li + li + li + li + li + li + li.current_page_item > a, 
#navigation > li + li + li + li + li + li + li + li + li.current_page_ancestor > a, 
#navigation > li + li + li + li + li + li + li + li + li.current-menu-ancestor > a,
.related_posts ul > li + li + li + li + li + li + li + li + li > a.current,
.tabs > li + li + li + li + li + li + li + li + li.current a, 
.tour  > li + li + li + li + li + li + li + li + li a:hover, 
.tour  > li + li + li + li + li + li + li + li + li.current a {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_9']; ?>;
}

#navigation > li + li + li + li + li + li + li + li + li + li:hover > a, 
#navigation > li + li + li + li + li + li + li + li + li + li:hover > a:hover, 
#navigation > li + li + li + li + li + li + li + li + li + li.current_page_item > a, 
#navigation > li + li + li + li + li + li + li + li + li + li.current_page_ancestor > a, 
#navigation > li + li + li + li + li + li + li + li + li + li.current-menu-ancestor > a,
.related_posts ul > li + li + li + li + li + li + li + li + li + li > a.current,
.tabs > li + li + li + li + li + li + li + li + li + li.current a, 
.tour  > li + li + li + li + li + li + li + li + li + li a:hover, 
.tour  > li + li + li + li + li + li + li + li + li + li.current a {
	background-color:<?php echo $cmsms_option[CMSMS_SHORTNAME . '_nav_title_bg_color_10']; ?>;
}


/* =================> Social Icons Background Colors <================ */

<?php 
$i = 1;

foreach ($cmsms_option[CMSMS_SHORTNAME . '_social_icons'] as $cmsms_social_icons) {
	$cmsms_social_icon = explode('|', str_replace(' ', '', $cmsms_social_icons));
	
	echo '#header .social_icons li:nth-child(' . $i . '):hover,#middle .social_icons li:nth-child(' . $i . '):hover, #footer .social_icons li:nth-child(' . $i . '):hover {border-color:' . $cmsms_social_icon[1] . ';}' . "\n";
	
	$i++;
}
?>
